/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.characterviewer;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.RandomXS128;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.google.inject.Inject;
import java.util.Map;
import technology.rocketjump.undermount.assets.GameMaterialDictionary;
import technology.rocketjump.undermount.assets.entities.EntityAssetTypeDictionary;
import technology.rocketjump.undermount.assets.entities.item.model.ItemSize;
import technology.rocketjump.undermount.assets.entities.model.ColoringLayer;
import technology.rocketjump.undermount.assets.entities.model.EntityAsset;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetType;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.entities.EntityAssetUpdater;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemType;
import technology.rocketjump.undermount.entities.model.physical.item.ItemTypeDictionary;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpecies;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesDictionary;

public class ItemViewerUI
implements Disposable {
    private final EntityAssetUpdater entityAssetUpdater;
    private Skin uiSkin = new Skin(Gdx.files.internal("assets/ui-skins/libgdx-default/uiskin.json"));
    private Stage stage;
    private Table containerTable;
    private TextButton backgroundMatButton;
    private TextButton mainMatButton;
    private TextButton seedButton;
    private Entity currentEntity;
    private Map<EntityAssetType, EntityAsset> assetMap;
    private ItemEntityAttributes entityAttributes;
    private final EntityAssetTypeDictionary assetTypeDictionary;
    private final ItemTypeDictionary itemTypeDictionary;
    private final GameMaterialDictionary gameMaterialDictionary;
    private final PlantSpeciesDictionary plantSpeciesDictionary;

    @Inject
    public ItemViewerUI(EntityAssetUpdater entityAssetUpdater, EntityAssetTypeDictionary assetTypeDictionary, ItemTypeDictionary itemTypeDictionary, GameMaterialDictionary gameMaterialDictionary, PlantSpeciesDictionary plantSpeciesDictionary) {
        this.entityAssetUpdater = entityAssetUpdater;
        this.assetTypeDictionary = assetTypeDictionary;
        this.itemTypeDictionary = itemTypeDictionary;
        this.gameMaterialDictionary = gameMaterialDictionary;
        this.plantSpeciesDictionary = plantSpeciesDictionary;
        this.stage = new Stage(new ScreenViewport());
        this.containerTable = new Table(this.uiSkin);
        this.containerTable.setFillParent(true);
        this.stage.addActor(this.containerTable);
        this.containerTable.pad(20.0f);
        this.containerTable.left().top();
    }

    public void init(Entity entity) {
        this.currentEntity = entity;
        this.entityAttributes = (ItemEntityAttributes)entity.getPhysicalEntityComponent().getAttributes();
        this.assetMap = entity.getPhysicalEntityComponent().getTypeMap();
        this.containerTable.clearChildren();
        this.createItemTypeWidget();
        this.containerTable.row();
        this.createItemSizeWidget();
        this.containerTable.row();
        this.createMaterialWidget(GameMaterialType.STONE);
        this.containerTable.row();
        this.createMaterialWidget(GameMaterialType.ORE);
        this.containerTable.row();
        this.createMaterialWidget(GameMaterialType.GEM);
        this.containerTable.row();
        this.createMaterialWidget(GameMaterialType.WOOD);
        this.containerTable.row();
        this.createMaterialWidget(GameMaterialType.METAL);
        this.containerTable.row();
        this.createTreeSpeciesWidget();
        this.containerTable.row();
        this.createQuantityWidget();
        this.containerTable.row();
        this.createSeedWidget();
        this.containerTable.row();
    }

    private void createSeedWidget() {
        this.containerTable.add(new Label((CharSequence)"Seed: ", this.uiSkin));
        this.seedButton = new TextButton("#0", this.uiSkin);
        this.seedButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                long nextSeed = ItemViewerUI.this.entityAttributes.getSeed() + 1L;
                ItemViewerUI.this.entityAttributes.setSeed(nextSeed);
                ItemViewerUI.this.entityAssetUpdater.updateEntityAssets(ItemViewerUI.this.currentEntity);
                ItemViewerUI.this.seedButton.setText("#" + nextSeed);
            }
        });
        this.containerTable.add(this.seedButton);
    }

    private void createItemSizeWidget() {
        this.containerTable.add(new Label((CharSequence)"Size: ", this.uiSkin));
        final SelectBox itemSizeSelect = new SelectBox(this.uiSkin);
        Array<String> sizeStrings = new Array<String>();
        for (ItemSize itemSize : ItemSize.values()) {
            sizeStrings.add(itemSize.name());
        }
        itemSizeSelect.setItems(sizeStrings);
        itemSizeSelect.setSelected(String.valueOf((Object)this.entityAttributes.getItemSize()));
        itemSizeSelect.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ItemSize selectedSize = ItemSize.valueOf((String)itemSizeSelect.getSelected());
                ItemViewerUI.this.entityAttributes.setItemSize(selectedSize);
                ItemViewerUI.this.entityAssetUpdater.updateEntityAssets(ItemViewerUI.this.currentEntity);
            }
        });
        this.containerTable.add(itemSizeSelect);
    }

    private void createItemTypeWidget() {
        final SelectBox itemTypeSelect = new SelectBox(this.uiSkin);
        Array<String> itemTypeNames = new Array<String>();
        for (ItemType itemType : this.itemTypeDictionary.getAll()) {
            itemTypeNames.add(itemType.getItemTypeName());
        }
        itemTypeSelect.setItems(itemTypeNames);
        itemTypeSelect.setSelected(this.entityAttributes.getItemType().getItemTypeName());
        itemTypeSelect.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                String selectedTypeName = (String)itemTypeSelect.getSelected();
                ItemType selectedType = ItemViewerUI.this.itemTypeDictionary.getByName(selectedTypeName);
                ItemViewerUI.this.entityAttributes.setItemType(selectedType);
                ItemViewerUI.this.entityAssetUpdater.updateEntityAssets(ItemViewerUI.this.currentEntity);
            }
        });
        this.containerTable.add(new Label((CharSequence)"Item Type:", this.uiSkin), itemTypeSelect);
    }

    private void createMaterialWidget(GameMaterialType materialType) {
        final SelectBox materialSelect = new SelectBox(this.uiSkin);
        Array<String> materialNames = new Array<String>();
        for (GameMaterial material : this.gameMaterialDictionary.getAll()) {
            if (!material.getMaterialType().equals((Object)materialType)) continue;
            materialNames.add(material.getMaterialName());
        }
        materialSelect.setItems(materialNames);
        materialSelect.setSelected(this.entityAttributes.getMaterial(materialType).getMaterialName());
        materialSelect.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                String selectedMaterialName = (String)materialSelect.getSelected();
                GameMaterial selectedMaterial = ItemViewerUI.this.gameMaterialDictionary.getByName(selectedMaterialName);
                ItemViewerUI.this.entityAttributes.setMaterial(selectedMaterial);
            }
        });
        this.containerTable.add(new Label((CharSequence)(materialType.name() + " material:"), this.uiSkin), materialSelect);
    }

    private void createTreeSpeciesWidget() {
        final SelectBox treeSelect = new SelectBox(this.uiSkin);
        Array<String> speciesNames = new Array<String>();
        for (PlantSpecies species : this.plantSpeciesDictionary.getAll()) {
            if (species.getItem() == null) continue;
            speciesNames.add(species.getSpeciesName());
        }
        treeSelect.setItems(speciesNames);
        treeSelect.setSelected("Oak");
        treeSelect.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                String selectedName = (String)treeSelect.getSelected();
                PlantSpecies plantSpecies = ItemViewerUI.this.plantSpeciesDictionary.getByName(selectedName);
                ItemViewerUI.this.entityAttributes.setMaterial(plantSpecies.getBranchMaterial());
                ItemViewerUI.this.entityAttributes.setColor(ColoringLayer.BRANCHES_COLOR, plantSpecies.randomBranchColor(new RandomXS128()));
                ItemViewerUI.this.entityAttributes.setItemSize(plantSpecies.getItem().getItemSize());
                ItemViewerUI.this.entityAttributes.setItemStyle(plantSpecies.getItem().getItemStyle());
                ItemViewerUI.this.entityAssetUpdater.updateEntityAssets(ItemViewerUI.this.currentEntity);
            }
        });
        this.containerTable.add(new Label((CharSequence)"Tree species: ", this.uiSkin), treeSelect);
    }

    private void createQuantityWidget() {
        final SelectBox quantitySelect = new SelectBox(this.uiSkin);
        Array<String> quantityNames = new Array<String>();
        for (int i = 1; i <= 25; ++i) {
            quantityNames.add(String.valueOf(i));
        }
        quantitySelect.setItems(quantityNames);
        quantitySelect.setSelected(String.valueOf(this.entityAttributes.getQuantity()));
        quantitySelect.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                int selectedQuantity = Integer.valueOf((String)quantitySelect.getSelected());
                ItemViewerUI.this.entityAttributes.setQuantity(selectedQuantity);
                ItemViewerUI.this.entityAssetUpdater.updateEntityAssets(ItemViewerUI.this.currentEntity);
            }
        });
        this.containerTable.add(new Label((CharSequence)"Quantity: ", this.uiSkin), quantitySelect);
    }

    public void render() {
        this.stage.act();
        this.stage.draw();
    }

    public void onResize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void dispose() {
        this.stage.dispose();
    }

    public void updateAttributes(ItemEntityAttributes entityAttributes) {
        this.entityAttributes = entityAttributes;
    }

    private String colorToString(Color color) {
        return "#" + color.toString().substring(0, 6);
    }

    public Stage getStage() {
        return this.stage;
    }
}

